/*{
	"GUID":"BB101941-A166-4332-B70F-22DD4B4236BD",
	"INPUTS":[
		{
			"TYPE":"image",
			"FILE":"xproMap.png"
		},
		{
			"TYPE":"image",
			"FILE":"vignetteMap.png"
		}
	],
	"PARAMS":[
		{
			"NAME":"strength",
			"TYPE":"float",
			"DEFAULT":1.0,
			"MIN":0.0,
			"MAX":1.0
		}
	]
}*/
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc).zyxw;
}


__kernel void MAIN(__read_only image2d_t input1, 
	__read_only image2d_t input2,
	__read_only image2d_t input3, 
	__write_only image2d_t dest_data,
	__global FilterParam* param,
	int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (float2)(0.5f)) / (float2)(W,H);
	
	vec4 orig = INPUTSRC(input1, param, tc);
	vec3 texel = orig.xyz;
     
    texel = (vec3)(
                  INPUT(input2, (vec2)(texel.x, .16666f)).x,
                  INPUT(input2, (vec2)(texel.y, .5f)).y,
                  INPUT(input2, (vec2)(texel.z, .83333f)).z);
     
    vec2 tt = (2.0f * tc) - 1.0f;
    float d = dot(tt, tt);
    vec2 lookup = (vec2)(d, texel.x);
    texel.x = INPUT(input3, lookup).x;
    lookup.y = texel.y;
    texel.y = INPUT(input3, lookup).y;
    lookup.y = texel.z;
    texel.z = INPUT(input3, lookup).z;
	
	vec2 red = (vec2)(texel.x, 0.16666f);
    vec2 green = (vec2)(texel.y, 0.5f);
    vec2 blue = (vec2)(texel.z, .83333f);
    texel.x = INPUT(input2, red).x;
    texel.y = INPUT(input2, green).y;
    texel.z = INPUT(input2, blue).z;
     
    write_imagef(dest_data, coordinate, mix((vec4)(texel.zyx, orig.w), orig.zyxw, (vec4)(1.0f - (alpha/100.0f))));

}